#include <stdio.h>
#include <cups/cups.h>

int main()
{
	///////////////////////////////////////////////////////////////////////////////////
	////   If you print via CUPS, you can get the status values as shown below.      //
	////                                                       			 //
	////   Build command : gcc -o statusCheckSample.out statusCheckSample.c -lcups   //
	///////////////////////////////////////////////////////////////////////////////////
	cups_dest_t *dests = NULL, *dest = NULL;
	const char *printerName = "BIXOLON_SLP-DL410";
	const char *status = NULL;
	int nDests = 0, i = 0;
	char printCommand[256] = {0, };

	sprintf(printCommand, "lp -d %s PrinterInitCmd.txt", printerName);
	for(i = 1; i <= 2; i++) // Sometimes CUPS API cannot read status value from printer. try to read twice or more.
	{
		system(printCommand);
		usleep(700000);
	}
	
	nDests = cupsGetDests(&dests);
	if(dests == NULL)
	{
		return 0;
	}
	dest   = cupsGetDest(printerName, NULL, nDests, dests);
	if(dest == NULL)
	{
		cupsFreeDests(1, dest);
		return 0;
	}
	status = cupsGetOption("printer-state-reasons", dest->num_options, dest->options);

	// Paper out    : media-empty
	// Cover open   : cover-open
	// Cutter jam   : cutter-jam
	// TPH overheat : TPH-overheat
	// Paper jam, Gap Detection Error : media-jam
	printf("The printer(%s) status : %s\n", printerName, status);

	cupsFreeDests(nDests, dests);
	
	return 0;
}
