#!/bin/sh
 
# Setup variables
EXEC=/usr/local/bin/jsvc
JAVA_HOME=/usr/java/jdk1.7.0_71
CLASS_HOME="/home/user/Server"
CLASS_PATH="$CLASS_HOME/lib/commons-daemon-1.0.15.jar":"$CLASS_HOME/KsefSrvNix.jar"
CLASS=KsefSrvPackage.MainClass
# OPTIONS позволяет задать дополнительные опции, будь то порт или режим отладки
# OPTIONS="--port=3155"
OPTIONS="--port=2188 --debug"
USER=user
PID=/var/run/KsefSrvNix.pid
LOG_OUT=$CLASS_HOME/srv.log
LOG_ERR=$CLASS_HOME/srv.err
PROCNAME=KsefSrvNix
 
do_exec()
{
    $EXEC -home "$JAVA_HOME" -procname $PROCNAME -cp $CLASS_PATH -user $USER -outfile $LOG_OUT -errfile $LOG_ERR -pidfile $PID $1 $CLASS $OPTIONS
}
 
case "$1" in
    start)
        do_exec
            ;;
    stop)
        do_exec "-stop"
            ;;
    restart)
        if [ -f "$PID" ]; then
            do_exec "-stop"
            do_exec
        else
            echo "service not running."
            exit 1
        fi
            ;;
    *)
            echo "usage: daemon {start|stop|restart}" >&2
            exit 3
            ;;
esac

