/*
 * Decompiled with CFR 0.152.
 */
package KSEFViewPackage;

import KSEFViewPackage.About;
import KSEFViewPackage.FileTree;
import KSEFViewPackage.ProductCode;
import KSEFViewPackage.VPC;
import KSEFViewPackage.XMLParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class MainClass {
    private static final int frameWidth = 800;
    private static final int frameHeight = 400;
    private static final int borderInsets = 5;
    private static final int borderGaps = 5;
    private static final int e_panelWidth = 150;
    private static final int treeWidth = 200;
    private static final int textWidth = 400;
    public static JFrame frame;
    private static JPanel panel;
    private static JScrollPane sp;
    private static FileTree tree;
    private static JEditorPane text;
    private static JTextField findPacket;
    private static URL file;
    private static Preferences pref;
    private static File defaultDir;
    private static JTextField findText;
    private static JList<Integer> list;
    private static JLabel infolabel;
    public static XMLParser parser;
    private static Boolean authcopy;

    static {
        pref = Preferences.userRoot();
        defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
        list = new JList();
        infolabel = new JLabel();
        parser = new XMLParser();
        authcopy = false;
    }

    public static void updateInfo(String info) {
        infolabel.setText(info);
    }

    public static void updatePacketList(ArrayList<Integer> packetList) {
        Integer[] arr = new Integer[packetList.size()];
        int i = 0;
        while (i < packetList.size()) {
            arr[i] = packetList.get(i);
            ++i;
        }
        list.setListData((Integer[])arr);
        list.setSelectedIndex(0);
        MainClass.showPacket();
    }

    public static void eraseFindPacket() {
        findPacket.setText("");
    }

    private static void showPacket() {
        ArrayList<String> packetText = parser.getPacketBody(list.getSelectedValue());
        if (packetText != null) {
            String serial = "";
            for (String str : packetText) {
                serial = String.valueOf(serial) + str;
            }
            text.setText(serial);
            text.setCaretPosition(0);
            sp.setMinimumSize(new Dimension(text.getWidth(), text.getHeight()));
            text.repaint();
        }
    }

    public static void main(String[] args) {
        VPC hw;
        int length;
        File f = new File(new File(".") + File.separator + "license.key");
        String s = null;
        if (Files.exists(Paths.get(f.getPath(), new String[0]), new LinkOption[0]) && (length = (int)f.length()) != 0) {
            char[] cbuf = new char[length];
            InputStreamReader isr = null;
            try {
                isr = new InputStreamReader((InputStream)new FileInputStream(f), "CP1251");
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            int read = 0;
            try {
                read = isr.read(cbuf);
                isr.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            s = new String(cbuf, 0, read);
        }
        if (s == null) {
            s = pref.get("LCPST", null);
        }
        if (s != null && (hw = new VPC()).v2gtvpk(s) == 0) {
            authcopy = true;
            pref.put("LCPST", s);
        }
        String pc = null;
        try {
            ProductCode hw2 = new ProductCode();
            pc = hw2.getProductCode();
            pref.put("PRODUCT_CODE", pc);
        }
        catch (NullPointerException e) {
            JOptionPane.showMessageDialog(frame, e.getMessage(), null, 0);
        }
        catch (UnsatisfiedLinkError e) {
            JOptionPane.showMessageDialog(frame, e.getMessage(), null, 0);
        }
        catch (SecurityException e) {
            JOptionPane.showMessageDialog(frame, e.getMessage(), null, 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, e.getMessage(), null, 0);
        }
        if (!authcopy.booleanValue()) {
            JOptionPane.showMessageDialog(frame, "\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0440\u0430\u0431\u043e\u0430\u0435\u0442 \u0432 \u0434\u0435\u043c\u043e-\u0440\u0435\u0436\u0438\u043c\u0435.\n \u041a\u043e\u0434 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430: " + pc, "\u041a\u043e\u043f\u0438\u044f \u043d\u0435 \u0437\u0430\u0440\u0435\u0433\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0430", 2);
        }
        frame = new JFrame("KSEF View");
        frame.setDefaultCloseOperation(3);
        Image img = new ImageIcon(MainClass.class.getClassLoader().getResource("resources/msdc32.png")).getImage();
        frame.setIconImage(img);
        panel = new JPanel(new BorderLayout());
        JPanel w_panel = new JPanel(new BorderLayout(5, 5));
        w_panel.setBorder(new EmptyBorder(new Insets(0, 5, 0, 5)));
        String path = pref.get("DEFAULT_PATH", "");
        if (path.length() != 0) {
            defaultDir = new File(path);
        }
        tree = new FileTree(defaultDir);
        tree.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        tree.setPreferredSize(new Dimension(200, tree.getHeight()));
        w_panel.add((Component)tree, "Center");
        panel.add((Component)w_panel, "West");
        JPanel c_panel = new JPanel();
        c_panel.setBackground(Color.GRAY);
        c_panel.setBorder(BorderFactory.createLineBorder(Color.GRAY, 10));
        c_panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.fill = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        text = new JEditorPane();
        text.setPreferredSize(new Dimension(400, text.getHeight()));
        text.setAutoscrolls(true);
        text.setEditable(false);
        text.setContentType("text/html");
        sp = new JScrollPane(text);
        sp.setHorizontalScrollBarPolicy(31);
        sp.setMinimumSize(new Dimension(text.getWidth(), text.getHeight()));
        c_panel.add((Component)sp, constraints);
        panel.add((Component)c_panel, "Center");
        JPanel e_panel = new JPanel(new BorderLayout(5, 5));
        e_panel.setPreferredSize(new Dimension(150, e_panel.getHeight()));
        e_panel.setBorder(new EmptyBorder(new Insets(0, 5, 0, 5)));
        findPacket = new JTextField();
        findPacket.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                for (Integer packet : MainClass.parser.packetList) {
                    if (!packet.toString().startsWith(findPacket.getText())) continue;
                    list.setSelectedIndex(MainClass.parser.packetList.indexOf(packet));
                    list.ensureIndexIsVisible(MainClass.parser.packetList.indexOf(packet));
                    MainClass.showPacket();
                    break;
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                for (Integer packet : MainClass.parser.packetList) {
                    if (!packet.toString().startsWith(findPacket.getText())) continue;
                    list.setSelectedIndex(MainClass.parser.packetList.indexOf(packet));
                    list.ensureIndexIsVisible(MainClass.parser.packetList.indexOf(packet));
                    MainClass.showPacket();
                    break;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                for (Integer packet : MainClass.parser.packetList) {
                    if (!packet.toString().startsWith(findPacket.getText())) continue;
                    list.setSelectedIndex(MainClass.parser.packetList.indexOf(packet));
                    list.ensureIndexIsVisible(MainClass.parser.packetList.indexOf(packet));
                    MainClass.showPacket();
                    break;
                }
            }
        });
        e_panel.add((Component)findPacket, "North");
        JScrollPane sp_list = new JScrollPane(list);
        sp_list.setHorizontalScrollBarPolicy(31);
        if (!authcopy.booleanValue()) {
            list.setEnabled(false);
            findPacket.setEnabled(false);
        }
        e_panel.add((Component)sp_list, "Center");
        panel.add((Component)e_panel, "East");
        Box box = new Box(2);
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton btn1 = new JButton("\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
        file = MainClass.class.getClassLoader().getResource("resources/database32.png");
        btn1.setIcon(new ImageIcon(file));
        btn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setCurrentDirectory(new File(pref.get("DEFAULT_PATH", defaultDir.getAbsolutePath())));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setApproveButtonText("\u0412\u044b\u0431\u0440\u0430\u0442\u044c");
                if (chooser.showDialog(null, "\u0412\u044b\u0431\u043e\u0440 \u0440\u0430\u0431\u043e\u0447\u0435\u0433\u043e \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430") == 0) {
                    pref.put("DEFAULT_PATH", chooser.getSelectedFile().getAbsolutePath());
                    tree.updateNodes(chooser.getSelectedFile());
                }
            }
        });
        box.add(btn1);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        JButton btn2 = new JButton("\u041f\u0435\u0447\u0430\u0442\u044c");
        file = MainClass.class.getClassLoader().getResource("resources/printer32.png");
        btn2.setIcon(new ImageIcon(file));
        btn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MessageFormat head = new MessageFormat("");
                    MessageFormat foot = new MessageFormat("");
                    PrinterJob pj = PrinterJob.getPrinterJob();
                    PageFormat pf = pj.pageDialog(pj.defaultPage());
                    Paper paper = new Paper();
                    double margin = 10.0;
                    paper.setSize(420.0, paper.getHeight());
                    paper.setImageableArea(10.0, 10.0, 410.0, (double)text.getHeight() + 10.0);
                    pf.setPaper(paper);
                    pf.setOrientation(1);
                    pj.setPrintable(text.getPrintable(head, foot), pf);
                    if (pj.printDialog()) {
                        pj.print();
                    }
                }
                catch (PrinterException err) {
                    System.err.println(err);
                }
            }
        });
        box.add(btn2);
        box.add(Box.createRigidArea(new Dimension(20, 0)));
        box.add(new JLabel("\u041f\u043e\u0438\u0441\u043a:"));
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        findText = new JTextField();
        findText.setMargin(new Insets(0, 10, 0, 10));
        findText.setFont(new Font(findText.getFont().getFontName(), 0, 20));
        findText.setHorizontalAlignment(2);
        box.add(findText);
        box.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton btn3 = new JButton();
        file = MainClass.class.getClassLoader().getResource("resources/search32.png");
        btn3.setIcon(new ImageIcon(file));
        if (!authcopy.booleanValue()) {
            btn3.setEnabled(false);
        }
        btn3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean fl = false;
                if (findText.getText().isEmpty()) {
                    return;
                }
                if (MainClass.parser.packetList.isEmpty()) {
                    JOptionPane.showMessageDialog(frame, "\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u043f\u0443\u0441\u0442!", "\u041f\u043e\u0438\u0441\u043a", 0);
                }
                block7: for (Integer packet : MainClass.parser.packetList) {
                    ArrayList<String> packetText = parser.getPacketBody(packet);
                    JEditorPane pane = new JEditorPane();
                    pane.setContentType("text/html");
                    String serial = "";
                    if (packetText != null) {
                        for (String str : packetText) {
                            serial = String.valueOf(serial) + str;
                        }
                    }
                    pane.setText(serial.toLowerCase());
                    int position = 0;
                    try {
                        while (pane.getDocument().getText(position, pane.getDocument().getLength() - position).contains(findText.getText().trim().toLowerCase())) {
                            Object[] options;
                            int res;
                            fl = true;
                            list.setSelectedIndex(MainClass.parser.packetList.indexOf(packet));
                            list.ensureIndexIsVisible(MainClass.parser.packetList.indexOf(packet));
                            MainClass.showPacket();
                            int startPos = -1;
                            try {
                                startPos = text.getDocument().getText(position, text.getDocument().getLength() - position).toLowerCase().indexOf(findText.getText().trim().toLowerCase());
                            }
                            catch (BadLocationException err) {
                                System.err.println(err);
                                break;
                            }
                            int endPos = startPos + findText.getText().trim().length();
                            try {
                                text.getHighlighter().addHighlight(position + startPos, position + endPos, new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY));
                            }
                            catch (Exception err) {
                                System.err.println(err);
                                break;
                            }
                            text.repaint();
                            if (startPos != -1) {
                                text.setCaretPosition(position += endPos);
                            }
                            if ((res = JOptionPane.showOptionDialog(frame, "\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c \u043f\u043e\u0438\u0441\u043a?", "\u041f\u043e\u0438\u0441\u043a", 0, 3, null, options = new Object[]{"\u0414\u0430", "\u041d\u0435\u0442"}, options[0])) == 1 || res == -1) break block7;
                        }
                    }
                    catch (HeadlessException err) {
                        System.err.println(err);
                    }
                    catch (BadLocationException err) {
                        System.err.println(err);
                    }
                    if (packet != MainClass.parser.packetList.get(MainClass.parser.packetList.size() - 1)) continue;
                    String str = "\u041f\u043e\u0438\u0441\u043a \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d!";
                    if (!fl) {
                        str = String.valueOf(str) + "\n\u041f\u041e\u0418\u0421\u041a \u0420\u0415\u0417\u0423\u041b\u042c\u0422\u0410\u0422\u041e\u0412 \u041d\u0415 \u0414\u0410\u041b!";
                    }
                    JOptionPane.showMessageDialog(frame, str, "\u041f\u043e\u0438\u0441\u043a", 1);
                }
            }
        });
        box.add(btn3);
        box.add(Box.createRigidArea(new Dimension(8, 0)));
        JButton btn4 = new JButton();
        file = MainClass.class.getClassLoader().getResource("resources/about_32.png");
        btn4.setIcon(new ImageIcon(file));
        btn4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new About().create(authcopy);
            }
        });
        box.add(btn4);
        panel.add((Component)box, "North");
        Box infobox = new Box(2);
        infobox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel bottomlabel = new JLabel();
        bottomlabel.setText("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f.       ");
        infobox.add(bottomlabel);
        infobox.add(infolabel);
        panel.add((Component)infobox, "South");
        frame.add(panel);
        frame.setSize(800, 400);
        frame.setExtendedState(6);
        frame.setVisible(true);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    MainClass.showPacket();
                }
            }
        });
    }
}

