/*
 * Decompiled with CFR 0.152.
 */
package KSEFViewPackage;

import KSEFViewPackage.MainClass;
import KSEFViewPackage.MyRenderer;
import java.awt.BorderLayout;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

class FileTree
extends JTree {
    private static final long serialVersionUID = 1L;
    JTree tree;
    MutableTreeNode myNode;

    public static String getFileExtention(String fullPath) {
        int sepPos = fullPath.lastIndexOf(File.separator);
        String nameAndExt = fullPath.substring(sepPos + 1);
        int dotPos = nameAndExt.lastIndexOf(".");
        return dotPos != -1 ? nameAndExt.substring(dotPos + 1) : "";
    }

    public FileTree(File dir) {
        this.setLayout(new BorderLayout());
        this.myNode = this.addNodes(null, dir);
        this.tree = new JTree(this.myNode);
        this.tree.setCellRenderer(new MyRenderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)FileTree.this.tree.getLastSelectedPathComponent();
                File file = new File(String.valueOf(node.getParent().toString()) + File.separator + node.toString());
                if (file.exists() && file.isFile() && FileTree.getFileExtention(file.toString()).equals("xml") && MainClass.parser.loadXMLDocument(file) && MainClass.parser.packetList != null) {
                    MainClass.updatePacketList(MainClass.parser.packetList);
                    MainClass.eraseFindPacket();
                    StringBuilder sb = new StringBuilder();
                    String[] stringArray = MainClass.parser.getInfo();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (s != null) {
                            sb.append(String.valueOf(s) + " ");
                        }
                        ++n2;
                    }
                    MainClass.updateInfo(sb.toString());
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.getViewport().add(this.tree);
        this.add("Center", scrollpane);
    }

    public void updateNodes(File file) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        MutableTreeNode tn = this.myNode = this.addNodes(null, file);
        model.setRoot(tn);
    }

    DefaultMutableTreeNode addNodes(DefaultMutableTreeNode curTop, File dir) {
        String curPath = dir.getPath();
        DefaultMutableTreeNode curDir = new DefaultMutableTreeNode(curPath);
        if (curTop != null) {
            curTop.add(curDir);
        }
        Vector<String> ol = new Vector<String>();
        String[] tmp = dir.list();
        if (tmp == null) {
            return curTop;
        }
        int i = 0;
        while (i < tmp.length) {
            ol.addElement(tmp[i]);
            ++i;
        }
        Collections.sort(ol, String.CASE_INSENSITIVE_ORDER);
        Vector<String> files = new Vector<String>();
        int i2 = 0;
        while (i2 < ol.size()) {
            String thisObject = (String)ol.elementAt(i2);
            String newPath = curPath.equals(".") ? thisObject : String.valueOf(curPath) + File.separator + thisObject;
            if (Files.exists(Paths.get(newPath, new String[0]), new LinkOption[0])) {
                File f = new File(newPath);
                if (f.isDirectory()) {
                    this.addNodes(curDir, f);
                } else {
                    files.addElement(thisObject);
                }
            }
            ++i2;
        }
        int fnum = 0;
        while (fnum < files.size()) {
            curDir.add(new DefaultMutableTreeNode(files.elementAt(fnum)));
            ++fnum;
        }
        return curDir;
    }
}

