/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

class OptionValidator {
    OptionValidator() {
    }

    static void validateOption(String opt) throws IllegalArgumentException {
        if (opt == null) {
            return;
        }
        if (opt.length() == 1) {
            char ch = opt.charAt(0);
            if (!OptionValidator.isValidOpt(ch)) {
                throw new IllegalArgumentException("illegal option value '" + ch + "'");
            }
        } else {
            char[] chars = opt.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (!OptionValidator.isValidChar(chars[i])) {
                    throw new IllegalArgumentException("opt contains illegal character value '" + chars[i] + "'");
                }
                ++i;
            }
        }
    }

    private static boolean isValidOpt(char c) {
        return OptionValidator.isValidChar(c) || c == ' ' || c == '?' || c == '@';
    }

    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }
}

