/*
 * Decompiled with CFR 0.152.
 */
package KSEFSvcPackage;

import KSEFSvcPackage.LoadConfig;
import KSEFSvcPackage.PrintMessage;
import KSEFSvcPackage.TransformToXml;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.xml.parsers.ParserConfigurationException;

public class DaemonThread
extends Thread {
    static LoadConfig conf;
    static TransformToXml xml;
    static File myFolder;
    static Socket socket;
    static PrintMessage msg;

    static {
        msg = new PrintMessage();
    }

    public DaemonThread(String server, int port) {
        try {
            conf = new LoadConfig(server, port);
        }
        catch (IOException e) {
            msg.err(e.toString());
        }
        msg.out("Daemon (server address: " + conf.getSERVER_IP() + ", server port: " + conf.getSERVER_PORT() + ")...");
        myFolder = new File(conf.getIN_DATA_STRING_VALUE());
        xml = new TransformToXml();
    }

    private Boolean isKSFExtention(String fullPath) {
        int sepPos = fullPath.lastIndexOf(File.separator);
        String nameAndExt = fullPath.substring(sepPos + 1, fullPath.length());
        int dotPos = nameAndExt.lastIndexOf(".");
        if (dotPos == -1) {
            return false;
        }
        return nameAndExt.substring(dotPos + 1).toLowerCase().equals("ksf");
    }

    private static String getKSFFileName(String fullPath) {
        int sepPos = fullPath.lastIndexOf(File.separator);
        String fileName = fullPath.substring(sepPos + 1, fullPath.length());
        int dotPos = fileName.lastIndexOf(".");
        if (dotPos == -1) {
            return fileName;
        }
        return fileName.substring(0, dotPos);
    }

    private static Boolean moveToBackup(String source, String dest) {
        File f1 = new File(source);
        File f2 = new File(dest);
        if (f2.exists()) {
            f2.delete();
        }
        return f1.renameTo(f2);
    }

    private static boolean sendFile(String filepath, String sn) {
        int port = conf.getSERVER_PORT();
        String addres = conf.getSERVER_IP();
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(addres);
            socket = new Socket(ipAddress, port);
        }
        catch (UnknownHostException e) {
            msg.err(e.toString());
            return false;
        }
        catch (IOException e) {
            msg.err(e.toString());
            return false;
        }
        try {
            int count;
            DataOutputStream outD = new DataOutputStream(socket.getOutputStream());
            if (!LoadConfig.getPOSid().isEmpty()) {
                outD.writeUTF(LoadConfig.getPOSid().trim());
            } else {
                outD.writeUTF(sn);
            }
            File f = new File(filepath);
            outD.writeLong(f.length());
            outD.writeUTF(f.getName());
            FileInputStream in = new FileInputStream(f);
            byte[] buffer = new byte[0x2000000];
            while ((count = in.read(buffer)) != -1) {
                outD.write(buffer, 0, count);
            }
            outD.flush();
            in.close();
            socket.close();
        }
        catch (IOException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        while (true) {
            File[] files;
            if ((files = myFolder.listFiles()) != null) {
                int i = 0;
                while (i < files.length) {
                    block9: {
                        if (files[i].isFile() && this.isKSFExtention(files[i].toString()).booleanValue() && xml.openSourceFile(files[i].toString()).booleanValue() && xml.readSourceData().booleanValue() && xml.checkingIntegrity().booleanValue()) {
                            block10: {
                                msg.out("Source opened: " + files[i].toString());
                                try {
                                    String destFile = String.valueOf(conf.getOUT_DATA_STRING_VALUE()) + File.separator + DaemonThread.getKSFFileName(files[i].toString()) + ".xml";
                                    if (!xml.xmlSaveDOMDocument(destFile)) break block9;
                                    msg.out("Transmitted to: " + destFile);
                                    if (!conf.getDATA_TRANSMITTER_ENABLED()) break block10;
                                    if (!DaemonThread.sendFile(destFile, DaemonThread.xml.serial)) break block9;
                                    msg.out("Sent to server: " + destFile);
                                }
                                catch (ParserConfigurationException e) {
                                    msg.err(e.toString());
                                }
                            }
                            String backupFile = String.valueOf(conf.getBACKUP_DATA_STRING_VALUE()) + File.separator + DaemonThread.getKSFFileName(files[i].toString()) + ".bak";
                            if (DaemonThread.moveToBackup(files[i].toString(), backupFile).booleanValue()) {
                                msg.out("Saved to backup: " + backupFile);
                            }
                        }
                    }
                    ++i;
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                msg.err(e.toString());
                return;
            }
        }
    }

    public void stopServer() {
        msg.out("Daemon stopped...");
        System.exit(0);
    }
}

