/*
 * Decompiled with CFR 0.152.
 */
package KSEFSvcPackage;

import KSEFSvcPackage.KSEF_REC_CANCEL;
import KSEFSvcPackage.KSEF_REC_COMMENT;
import KSEFSvcPackage.KSEF_REC_DISCOUNT;
import KSEFSvcPackage.KSEF_REC_IO;
import KSEFSvcPackage.KSEF_REC_PAYMENT;
import KSEFSvcPackage.KSEF_REC_PERS;
import KSEFSvcPackage.KSEF_REC_RECEIPT_END;
import KSEFSvcPackage.KSEF_REC_RECEIPT_TAX;
import KSEFSvcPackage.KSEF_REC_REPORT_TAX;
import KSEFSvcPackage.KSEF_REC_SALE;
import KSEFSvcPackage.KSEF_REC_START;
import KSEFSvcPackage.KSEF_REC_VOID;
import KSEFSvcPackage.KSEF_REC_Z_REPORT;
import KSEFSvcPackage.LoadConfig;
import KSEFSvcPackage.PrintMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransformToXml {
    byte[] ebytes;
    final byte[] header = new byte[]{67, 82, 68, 46};
    private byte[] buffer = null;
    public String serial;
    static PrintMessage msg = new PrintMessage();
    FileInputStream inFile = null;
    DataInputStream inData = null;
    FileOutputStream outFile = null;
    DataOutputStream outData = null;
    SimpleDateFormat dtf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    SimpleDateFormat dtfs = new SimpleDateFormat("dd/MM/yyyy");
    Element rootElement;
    Element rootPacket;
    Document doc;
    String sourceFilePath;

    private static int unsignedToBytes(byte a) {
        int b = a & 0xFF;
        return b;
    }

    private static int byteArrayToInt(byte[] b) {
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb.getInt();
    }

    private static long byteArrayToLong(byte[] b) {
        if (b.length < 8) {
            byte[] a = new byte[8];
            int k = b.length - 1;
            byte[] byArray = b;
            int n = b.length;
            int n2 = 0;
            while (n2 < n) {
                byte i = byArray[n2];
                a[k--] = i;
                ++n2;
            }
            b = a;
        }
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb.getLong();
    }

    private static short byteArrayToShort(byte[] b) {
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb.getShort();
    }

    private static Date getDate(byte[] seconds) {
        int sec = TransformToXml.byteArrayToInt(seconds);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.add(13, sec);
        return calendar.getTime();
    }

    private static long decodeCode(byte[] code) {
        long result = 0L;
        int i = 0;
        byte[] byArray = code;
        int n = code.length;
        int n2 = 0;
        while (n2 < n) {
            byte c = byArray[n2];
            if (c == -1) break;
            result = ((byte)(c >>> 4) & 0xF) == 15 ? (result += (long)(c & 0xF) * Math.round(Math.pow(100.0, i))) : (result += (long)(((byte)(c >>> 4) & 0xF) * 10 + (c & 0xF)) * Math.round(Math.pow(100.0, i)));
            i = (byte)(i + 1);
            ++n2;
        }
        return result;
    }

    public Boolean openSourceFile(String filePath) {
        try {
            this.sourceFilePath = filePath;
            this.inFile = new FileInputStream(filePath);
            this.inData = new DataInputStream(this.inFile);
        }
        catch (FileNotFoundException e) {
            msg.out("Can not find file: " + filePath);
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    public Boolean readSourceData() {
        try {
            try {
                int bytesAvailable = this.inData.available();
                this.buffer = new byte[bytesAvailable];
                this.inData.read(this.buffer, 0, bytesAvailable);
            }
            catch (FileNotFoundException e) {
                msg.out("Can not read file source file");
                msg.err(e.toString());
                Boolean bl = false;
                try {
                    if (this.inData != null) {
                        this.inData.close();
                    }
                    if (this.inFile != null) {
                        this.inFile.close();
                    }
                }
                catch (IOException e2) {
                    msg.err(e2.toString());
                }
                return bl;
            }
            catch (IOException e) {
                msg.out("Input/Output error");
                msg.err(e.toString());
                Boolean bl = false;
                try {
                    if (this.inData != null) {
                        this.inData.close();
                    }
                    if (this.inFile != null) {
                        this.inFile.close();
                    }
                }
                catch (IOException e3) {
                    msg.err(e3.toString());
                }
                return bl;
            }
        }
        finally {
            try {
                if (this.inData != null) {
                    this.inData.close();
                }
                if (this.inFile != null) {
                    this.inFile.close();
                }
            }
            catch (IOException e) {
                msg.err(e.toString());
            }
        }
        return true;
    }

    public Boolean checkingIntegrity() {
        if (!Arrays.equals(Arrays.copyOf(this.buffer, 4), this.header)) {
            msg.out("no ksef format");
            return false;
        }
        int crc = 0;
        int i = 18;
        while (i < this.buffer.length - 2) {
            crc += TransformToXml.unsignedToBytes(this.buffer[i]);
            crc &= 0xFFFF;
            ++i;
        }
        int file_crc = TransformToXml.unsignedToBytes(this.buffer[this.buffer.length - 2]) + TransformToXml.unsignedToBytes(this.buffer[this.buffer.length - 1]) * 256;
        return file_crc == crc;
    }

    private boolean xml_tagSTART(KSEF_REC_START tagSTART, long packetID) {
        try {
            this.rootPacket = this.doc.createElement("PACKET");
            this.rootElement.appendChild(this.rootPacket);
            this.rootPacket.appendChild(this.doc.createComment("Packet information"));
            Element nodeInfo = this.doc.createElement("INFO");
            Attr attrPacketID = this.doc.createAttribute("PacketID");
            attrPacketID.setValue(Long.toString(packetID));
            nodeInfo.setAttributeNode(attrPacketID);
            Attr attrSerialNumber = this.doc.createAttribute("SerialNumber");
            attrSerialNumber.setValue(tagSTART.regInfo.serialNumber);
            nodeInfo.setAttributeNode(attrSerialNumber);
            this.serial = tagSTART.regInfo.serialNumber.trim();
            Attr attrFiscalNumber = this.doc.createAttribute("FiscalNumber");
            attrFiscalNumber.setValue(tagSTART.regInfo.fiscalNumber);
            nodeInfo.setAttributeNode(attrFiscalNumber);
            Attr attrTaxNumber = this.doc.createAttribute("TaxNumber");
            attrTaxNumber.setValue(tagSTART.regInfo.taxNumber);
            nodeInfo.setAttributeNode(attrTaxNumber);
            Attr attrID_Dev = this.doc.createAttribute("ID_Dev");
            attrID_Dev.setValue(Long.toString(TransformToXml.byteArrayToLong(tagSTART.mac.id_DEV)));
            nodeInfo.setAttributeNode(attrID_Dev);
            this.rootPacket.appendChild(nodeInfo);
            this.rootPacket.appendChild(this.doc.createComment("Begin of receipt"));
            Element nodeBegin = this.doc.createElement("BEGIN");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagSTART.oper));
            nodeBegin.setAttributeNode(attrOperID);
            Attr attrSentDate = this.doc.createAttribute("SendDT");
            attrSentDate.setValue(this.dtf.format(tagSTART.sendDateTime));
            nodeBegin.setAttributeNode(attrSentDate);
            Attr attrRecvDate = this.doc.createAttribute("RecvDT");
            attrRecvDate.setValue(this.dtf.format(tagSTART.recvDateTime));
            nodeBegin.setAttributeNode(attrRecvDate);
            Attr attrRecordsCnt = this.doc.createAttribute("RecordsCount");
            attrRecordsCnt.setValue(Integer.toString(tagSTART.recordsCount));
            nodeBegin.setAttributeNode(attrRecordsCnt);
            Attr attrRcptType = this.doc.createAttribute("ReceiptType");
            attrRcptType.setValue(Byte.toString(tagSTART.receiptType));
            nodeBegin.setAttributeNode(attrRcptType);
            Attr attrRcptDate = this.doc.createAttribute("ReceiptDT");
            attrRcptDate.setValue(this.dtf.format(tagSTART.receiptDateTime));
            nodeBegin.setAttributeNode(attrRcptDate);
            Attr attrCashierName = this.doc.createAttribute("CashierName");
            attrCashierName.setValue(tagSTART.cashierName);
            nodeBegin.setAttributeNode(attrCashierName);
            this.rootPacket.appendChild(nodeBegin);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagSALE(KSEF_REC_SALE tagSALE) {
        try {
            this.rootPacket.appendChild(this.doc.createComment("Rec item"));
            Element nodeSale = this.doc.createElement("SALE");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagSALE.oper));
            nodeSale.setAttributeNode(attrOperID);
            Attr attrNumber = this.doc.createAttribute("Number");
            attrNumber.setValue(Integer.toString(tagSALE.number));
            nodeSale.setAttributeNode(attrNumber);
            Attr attrTax = this.doc.createAttribute("Tax");
            attrTax.setValue(Byte.toString(tagSALE.tax));
            nodeSale.setAttributeNode(attrTax);
            Attr attrItemCode = this.doc.createAttribute("ItemCode");
            attrItemCode.setValue(Long.toString(TransformToXml.decodeCode(tagSALE.itemCode)));
            nodeSale.setAttributeNode(attrItemCode);
            Attr attrName = this.doc.createAttribute("ItemName");
            attrName.setValue(tagSALE.itemName);
            nodeSale.setAttributeNode(attrName);
            Attr attrItemSum = this.doc.createAttribute("ItemSum");
            attrItemSum.setValue(Integer.toString(tagSALE.itemSum));
            nodeSale.setAttributeNode(attrItemSum);
            Attr attrItemQty = this.doc.createAttribute("ItemQty");
            switch (tagSALE.itemUsePcn) {
                case 1: {
                    attrItemQty.setValue(String.format("%." + tagSALE.itemQtyPcn + "f", (double)tagSALE.itemQty / Math.pow(10.0, tagSALE.itemQtyPcn)));
                    break;
                }
                default: {
                    attrItemQty.setValue(String.format("%.3f", tagSALE.itemQty / 1000));
                }
            }
            nodeSale.setAttributeNode(attrItemQty);
            Attr attrItemPrice = this.doc.createAttribute("ItemPrice");
            attrItemPrice.setValue(Integer.toString(tagSALE.itemPrice));
            nodeSale.setAttributeNode(attrItemPrice);
            this.rootPacket.appendChild(nodeSale);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagPAYMENT(KSEF_REC_PAYMENT tagPAYMENT) {
        try {
            this.rootPacket.appendChild(this.doc.createComment("Rec payment"));
            Element nodePayment = this.doc.createElement("PAYMENT");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagPAYMENT.oper));
            nodePayment.setAttributeNode(attrOperID);
            Attr attrNumber = this.doc.createAttribute("Number");
            attrNumber.setValue(Integer.toString(tagPAYMENT.number));
            nodePayment.setAttributeNode(attrNumber);
            Attr attrPmtType = this.doc.createAttribute("PaymentType");
            attrPmtType.setValue(Byte.toString(tagPAYMENT.paymentType));
            nodePayment.setAttributeNode(attrPmtType);
            Attr attrPmtSum = this.doc.createAttribute("PaymentSum");
            attrPmtSum.setValue(Integer.toString(tagPAYMENT.paymentSum));
            nodePayment.setAttributeNode(attrPmtSum);
            Attr attrPmtRem = this.doc.createAttribute("PaymentRem");
            attrPmtRem.setValue(Integer.toString(tagPAYMENT.paymentRem));
            nodePayment.setAttributeNode(attrPmtRem);
            Attr attrPmtName = this.doc.createAttribute("PaymentName");
            attrPmtName.setValue(tagPAYMENT.paymentName);
            nodePayment.setAttributeNode(attrPmtName);
            Attr attrAuthCode = this.doc.createAttribute("AuthorizCode");
            attrAuthCode.setValue(tagPAYMENT.payTransactID);
            nodePayment.setAttributeNode(attrAuthCode);
            this.rootPacket.appendChild(nodePayment);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagEND(KSEF_REC_RECEIPT_END tagEND) {
        try {
            this.rootPacket.appendChild(this.doc.createComment("End of receipt"));
            Element nodeEnd = this.doc.createElement("END");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagEND.oper));
            nodeEnd.setAttributeNode(attrOperID);
            Attr attrNumber = this.doc.createAttribute("Number");
            attrNumber.setValue(Integer.toString(tagEND.number));
            nodeEnd.setAttributeNode(attrNumber);
            Attr attrRcptNumber = this.doc.createAttribute("ReceiptNo");
            attrRcptNumber.setValue(Long.toString(tagEND.receiptNo));
            nodeEnd.setAttributeNode(attrRcptNumber);
            nodeEnd.appendChild(this.doc.createComment("Receipt taxes"));
            int i = 0;
            while (i < 7) {
                Element nodeTax = this.doc.createElement("TAX" + (i + 1));
                Attr attrTaxFlags = this.doc.createAttribute("TaxFlags");
                attrTaxFlags.setValue(Byte.toString(tagEND.receiptTax[i].taxFlags));
                nodeTax.setAttributeNode(attrTaxFlags);
                Attr attrBaseTaxRate = this.doc.createAttribute("BaseTaxRate");
                attrBaseTaxRate.setValue(Integer.toString(tagEND.receiptTax[i].baseTaxPercent));
                nodeTax.setAttributeNode(attrBaseTaxRate);
                Attr attrAddTaxRate = this.doc.createAttribute("AddTaxRate");
                attrAddTaxRate.setValue(Integer.toString(tagEND.receiptTax[i].addTaxPercent));
                nodeTax.setAttributeNode(attrAddTaxRate);
                Attr attrBaseTaxSum = this.doc.createAttribute("BaseTaxSum");
                attrBaseTaxSum.setValue(Long.toString(tagEND.receiptTax[i].baseTaxSum));
                nodeTax.setAttributeNode(attrBaseTaxSum);
                Attr attrAddTaxSum = this.doc.createAttribute("AddTaxSum");
                attrAddTaxSum.setValue(Long.toString(tagEND.receiptTax[i].addTaxSum));
                nodeTax.setAttributeNode(attrAddTaxSum);
                Attr attrTurnSum = this.doc.createAttribute("TurnSum");
                attrTurnSum.setValue(Long.toString(tagEND.receiptTax[i].turnSum));
                nodeTax.setAttributeNode(attrTurnSum);
                nodeEnd.appendChild(nodeTax);
                ++i;
            }
            this.rootPacket.appendChild(nodeEnd);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagDISCOUNT(KSEF_REC_DISCOUNT tagDISCOUNT) {
        try {
            this.rootPacket.appendChild(this.doc.createComment("Rec discount"));
            Element nodeDiscount = this.doc.createElement("DISCOUNT");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagDISCOUNT.oper));
            nodeDiscount.setAttributeNode(attrOperID);
            Attr attrNumber = this.doc.createAttribute("Number");
            attrNumber.setValue(Integer.toString(tagDISCOUNT.number));
            nodeDiscount.setAttributeNode(attrNumber);
            Attr attrDscntMethod = this.doc.createAttribute("DiscountMethod");
            attrDscntMethod.setValue(Byte.toString(tagDISCOUNT.discountMethod));
            nodeDiscount.setAttributeNode(attrDscntMethod);
            Attr attrDscntType = this.doc.createAttribute("DiscountType");
            attrDscntType.setValue(Byte.toString(tagDISCOUNT.discountType));
            nodeDiscount.setAttributeNode(attrDscntType);
            Attr attrDscntValue = this.doc.createAttribute("DiscountPercent");
            attrDscntValue.setValue(Integer.toString(tagDISCOUNT.discountPercent));
            nodeDiscount.setAttributeNode(attrDscntValue);
            Attr attrDscntSum = this.doc.createAttribute("DiscountSum");
            attrDscntSum.setValue(Integer.toString(tagDISCOUNT.discountSum));
            nodeDiscount.setAttributeNode(attrDscntSum);
            nodeDiscount.appendChild(this.doc.createComment("Discount tax sum"));
            int i = 0;
            while (i < 8) {
                Element nodeTax = this.doc.createElement("TAX" + (i + 1));
                Attr attrDscntTaxSum = this.doc.createAttribute("DiscountTaxSum");
                attrDscntTaxSum.setValue(Integer.toString(tagDISCOUNT.discountTaxSum[i]));
                nodeTax.setAttributeNode(attrDscntTaxSum);
                nodeDiscount.appendChild(nodeTax);
                ++i;
            }
            Attr attrTransactionID = this.doc.createAttribute("TransactionID");
            attrTransactionID.setValue(tagDISCOUNT.discTransactID);
            nodeDiscount.setAttributeNode(attrDscntSum);
            Attr attrDiscountName = this.doc.createAttribute("DiscountName");
            attrDiscountName.setValue(tagDISCOUNT.discountName);
            nodeDiscount.setAttributeNode(attrDiscountName);
            this.rootPacket.appendChild(nodeDiscount);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagIO(KSEF_REC_IO tagIO) {
        try {
            this.rootPacket.appendChild(this.doc.createComment("Rec input/output cash"));
            Element nodeIO = this.doc.createElement("IO");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagIO.oper));
            nodeIO.setAttributeNode(attrOperID);
            Attr attrNumber = this.doc.createAttribute("Number");
            attrNumber.setValue(Integer.toString(tagIO.number));
            nodeIO.setAttributeNode(attrNumber);
            Attr attrIOType = this.doc.createAttribute("IOType");
            attrIOType.setValue(Byte.toString(tagIO.ioType));
            nodeIO.setAttributeNode(attrIOType);
            Attr attrIOSum = this.doc.createAttribute("IOSum");
            attrIOSum.setValue(Integer.toString(tagIO.ioSum));
            nodeIO.setAttributeNode(attrIOSum);
            Attr attrIODrawerSum = this.doc.createAttribute("IODrawerSum");
            attrIODrawerSum.setValue(Integer.toString(tagIO.ioDrawerSum));
            nodeIO.setAttributeNode(attrIODrawerSum);
            this.rootPacket.appendChild(nodeIO);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagCOMMENT(KSEF_REC_COMMENT tagCOMMENT) {
        try {
            this.rootPacket.appendChild(this.doc.createComment("Rec comment line"));
            Element nodeComment = this.doc.createElement("COMMENT");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagCOMMENT.oper));
            nodeComment.setAttributeNode(attrOperID);
            Attr attrNumber = this.doc.createAttribute("Number");
            attrNumber.setValue(Integer.toString(tagCOMMENT.number));
            nodeComment.setAttributeNode(attrNumber);
            Attr attrCmtType = this.doc.createAttribute("CommentType");
            attrCmtType.setValue(Byte.toString(tagCOMMENT.commentType));
            nodeComment.setAttributeNode(attrCmtType);
            Attr attrCmtText = this.doc.createAttribute("CommentText");
            attrCmtText.setValue(tagCOMMENT.commentText);
            nodeComment.setAttributeNode(attrCmtText);
            this.rootPacket.appendChild(nodeComment);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagVOID(KSEF_REC_VOID tagVOID) {
        try {
            this.rootPacket.appendChild(this.doc.createComment("Rec void"));
            Element nodeVoid = this.doc.createElement("VOID");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagVOID.oper));
            nodeVoid.setAttributeNode(attrOperID);
            Attr attrNumber = this.doc.createAttribute("Number");
            attrNumber.setValue(Integer.toString(tagVOID.number));
            nodeVoid.setAttributeNode(attrNumber);
            Attr attrVoidFO = this.doc.createAttribute("VoidFO");
            attrVoidFO.setValue(Integer.toString(tagVOID.voidFO));
            nodeVoid.setAttributeNode(attrVoidFO);
            Attr attrVoidLO = this.doc.createAttribute("VoidLO");
            attrVoidLO.setValue(Integer.toString(tagVOID.voidLO));
            nodeVoid.setAttributeNode(attrVoidLO);
            this.rootPacket.appendChild(nodeVoid);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagCANCEL(KSEF_REC_CANCEL tagCANCEL) {
        try {
            this.rootPacket.appendChild(this.doc.createComment("Cancel receipt"));
            Element nodeCancel = this.doc.createElement("CANCEL");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagCANCEL.oper));
            nodeCancel.setAttributeNode(attrOperID);
            Attr attrNumber = this.doc.createAttribute("Number");
            attrNumber.setValue(Integer.toString(tagCANCEL.number));
            nodeCancel.setAttributeNode(attrNumber);
            this.rootPacket.appendChild(nodeCancel);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagPERS(KSEF_REC_PERS tagPERS, long packetID) {
        try {
            this.rootPacket = this.doc.createElement("PACKET");
            this.rootElement.appendChild(this.rootPacket);
            this.rootPacket.appendChild(this.doc.createComment("Packet information"));
            Element nodeInfo = this.doc.createElement("INFO");
            Attr attrPacketID = this.doc.createAttribute("PacketID");
            attrPacketID.setValue(Long.toString(packetID));
            nodeInfo.setAttributeNode(attrPacketID);
            Attr attrSerialNumber = this.doc.createAttribute("SerialNumber");
            attrSerialNumber.setValue(tagPERS.regInfo.serialNumber);
            nodeInfo.setAttributeNode(attrSerialNumber);
            this.serial = tagPERS.regInfo.serialNumber.trim();
            Attr attrFiscalNumber = this.doc.createAttribute("FiscalNumber");
            attrFiscalNumber.setValue(tagPERS.regInfo.fiscalNumber);
            nodeInfo.setAttributeNode(attrFiscalNumber);
            Attr attrTaxNumber = this.doc.createAttribute("TaxNumber");
            attrTaxNumber.setValue(tagPERS.regInfo.taxNumber);
            nodeInfo.setAttributeNode(attrTaxNumber);
            this.rootPacket.appendChild(nodeInfo);
            this.rootPacket.appendChild(this.doc.createComment("Rec personalization"));
            Element nodePers = this.doc.createElement("PERS");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagPERS.oper));
            nodePers.setAttributeNode(attrOperID);
            Attr attrSendDT = this.doc.createAttribute("SendDT");
            attrSendDT.setValue(this.dtf.format(tagPERS.sendDateTime));
            nodePers.setAttributeNode(attrSendDT);
            Attr attrRecvDT = this.doc.createAttribute("RecvDT");
            attrRecvDT.setValue(this.dtf.format(tagPERS.recvDateTime));
            nodePers.setAttributeNode(attrRecvDT);
            Attr attrPersResult = this.doc.createAttribute("PersResult");
            attrPersResult.setValue(Integer.toString(tagPERS.regResult));
            nodePers.setAttributeNode(attrPersResult);
            this.rootPacket.appendChild(this.doc.createComment("Registration information"));
            this.rootPacket.appendChild(nodePers);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    private boolean xml_tagZ_REPORT(KSEF_REC_Z_REPORT tagZ_REPORT, long packetID) {
        try {
            this.rootPacket = this.doc.createElement("PACKET");
            this.rootElement.appendChild(this.rootPacket);
            this.rootPacket.appendChild(this.doc.createComment("Packet information"));
            Element nodeInfo = this.doc.createElement("INFO");
            Attr attrPacketID = this.doc.createAttribute("PacketID");
            attrPacketID.setValue(Long.toString(packetID));
            nodeInfo.setAttributeNode(attrPacketID);
            Attr attrSerialNumber = this.doc.createAttribute("SerialNumber");
            attrSerialNumber.setValue(tagZ_REPORT.regInfo.serialNumber);
            nodeInfo.setAttributeNode(attrSerialNumber);
            this.serial = tagZ_REPORT.regInfo.serialNumber.trim();
            Attr attrFiscalNumber = this.doc.createAttribute("FiscalNumber");
            attrFiscalNumber.setValue(tagZ_REPORT.regInfo.fiscalNumber);
            nodeInfo.setAttributeNode(attrFiscalNumber);
            Attr attrTaxNumber = this.doc.createAttribute("TaxNumber");
            attrTaxNumber.setValue(tagZ_REPORT.regInfo.taxNumber);
            nodeInfo.setAttributeNode(attrTaxNumber);
            Attr attrID_Dev = this.doc.createAttribute("ID_Dev");
            attrID_Dev.setValue(Long.toString(TransformToXml.byteArrayToLong(tagZ_REPORT.mac.id_DEV)));
            nodeInfo.setAttributeNode(attrID_Dev);
            this.rootPacket.appendChild(nodeInfo);
            this.rootPacket.appendChild(this.doc.createComment("Rec Z-report"));
            Element nodeZRep = this.doc.createElement("Z_REPORT");
            Attr attrOperID = this.doc.createAttribute("OperID");
            attrOperID.setValue(Byte.toString(tagZ_REPORT.oper));
            nodeZRep.setAttributeNode(attrOperID);
            Attr attrSendDT = this.doc.createAttribute("SendDT");
            attrSendDT.setValue(this.dtf.format(tagZ_REPORT.sendDateTime));
            nodeZRep.setAttributeNode(attrSendDT);
            Attr attrRecvDT = this.doc.createAttribute("RecvDT");
            attrRecvDT.setValue(this.dtf.format(tagZ_REPORT.recvDateTime));
            nodeZRep.setAttributeNode(attrRecvDT);
            Attr attrReportNo = this.doc.createAttribute("ReportNo");
            attrReportNo.setValue(Integer.toString(tagZ_REPORT.reportNo));
            nodeZRep.setAttributeNode(attrReportNo);
            Attr attrReportDT = this.doc.createAttribute("ReportDT");
            attrReportDT.setValue(this.dtf.format(tagZ_REPORT.reportDateTime));
            nodeZRep.setAttributeNode(attrReportDT);
            Attr attrSaleRcptCount = this.doc.createAttribute("SaleRcptCount");
            attrSaleRcptCount.setValue(Long.toString(tagZ_REPORT.saleRcptCount));
            nodeZRep.setAttributeNode(attrSaleRcptCount);
            Attr attrRefundRcptCount = this.doc.createAttribute("RefundRcptCount");
            attrRefundRcptCount.setValue(Long.toString(tagZ_REPORT.refundRcptCount));
            nodeZRep.setAttributeNode(attrRefundRcptCount);
            Attr attrCashierName = this.doc.createAttribute("CashierName");
            attrCashierName.setValue(tagZ_REPORT.cashierName);
            nodeZRep.setAttributeNode(attrCashierName);
            nodeZRep.appendChild(this.doc.createComment("Daily taxes by Z-report"));
            int i = 0;
            while (i < 8) {
                Element nodeTax = this.doc.createElement("TAX" + (i + 1));
                Attr attrTaxFlags = this.doc.createAttribute("TaxFlags");
                attrTaxFlags.setValue(Byte.toString(tagZ_REPORT.recReportTaxArr[i].taxFlags));
                nodeTax.setAttributeNode(attrTaxFlags);
                Attr attrTaxDate = this.doc.createAttribute("TaxDate");
                attrTaxDate.setValue(this.dtfs.format(tagZ_REPORT.recReportTaxArr[i].taxDate));
                nodeTax.setAttributeNode(attrTaxDate);
                Attr attrBaseTaxRate = this.doc.createAttribute("BaseTaxRate");
                attrBaseTaxRate.setValue(Integer.toString(tagZ_REPORT.recReportTaxArr[i].baseTaxPercent));
                nodeTax.setAttributeNode(attrBaseTaxRate);
                Attr attrAddTaxRate = this.doc.createAttribute("AddTaxRate");
                attrAddTaxRate.setValue(Integer.toString(tagZ_REPORT.recReportTaxArr[i].addTaxPercent));
                nodeTax.setAttributeNode(attrAddTaxRate);
                Attr attrBaseTaxInSum = this.doc.createAttribute("BaseTaxInSum");
                attrBaseTaxInSum.setValue(Integer.toString(tagZ_REPORT.recReportTaxArr[i].baseTaxInSum));
                nodeTax.setAttributeNode(attrBaseTaxInSum);
                Attr attrBaseTaxOutSum = this.doc.createAttribute("BaseTaxOutSum");
                attrBaseTaxOutSum.setValue(Integer.toString(tagZ_REPORT.recReportTaxArr[i].baseTaxOutSum));
                nodeTax.setAttributeNode(attrBaseTaxOutSum);
                Attr attrAddTaxInSum = this.doc.createAttribute("AddTaxInSum");
                attrAddTaxInSum.setValue(Integer.toString(tagZ_REPORT.recReportTaxArr[i].addTaxInSum));
                nodeTax.setAttributeNode(attrAddTaxInSum);
                Attr attrAddTaxOutSum = this.doc.createAttribute("AddTaxOutSum");
                attrAddTaxOutSum.setValue(Integer.toString(tagZ_REPORT.recReportTaxArr[i].addTaxOutSum));
                nodeTax.setAttributeNode(attrAddTaxOutSum);
                Attr attrTurnInSum = this.doc.createAttribute("TurnInSum");
                attrTurnInSum.setValue(Integer.toString(tagZ_REPORT.recReportTaxArr[i].turnInSum));
                nodeTax.setAttributeNode(attrTurnInSum);
                Attr attrTurnOutSum = this.doc.createAttribute("TurnOutSum");
                attrTurnOutSum.setValue(Integer.toString(tagZ_REPORT.recReportTaxArr[i].turnOutSum));
                nodeTax.setAttributeNode(attrTurnOutSum);
                nodeZRep.appendChild(nodeTax);
                ++i;
            }
            nodeZRep.appendChild(this.doc.createComment("Daily total sums by payment forms"));
            i = 0;
            while (i < 10) {
                Element nodePayment = this.doc.createElement("PAYMENT" + (i + 1));
                Attr attrSaleSum = this.doc.createAttribute("SaleSum");
                attrSaleSum.setValue(Long.toString(tagZ_REPORT.saleSumArr[i]));
                nodePayment.setAttributeNode(attrSaleSum);
                Attr attrRefundSum = this.doc.createAttribute("RefundSum");
                attrRefundSum.setValue(Long.toString(tagZ_REPORT.refundSumArr[i]));
                nodePayment.setAttributeNode(attrRefundSum);
                nodeZRep.appendChild(nodePayment);
                ++i;
            }
            nodeZRep.appendChild(this.doc.createComment("Daily sums of IO operation"));
            Element nodeIOTotal = this.doc.createElement("IO_TOTAL");
            Attr attrInSum = this.doc.createAttribute("InSum");
            attrInSum.setValue(Long.toString(tagZ_REPORT.inSum));
            nodeIOTotal.setAttributeNode(attrInSum);
            Attr attrOutSum = this.doc.createAttribute("OutSum");
            attrOutSum.setValue(Long.toString(tagZ_REPORT.outSum));
            nodeIOTotal.setAttributeNode(attrOutSum);
            nodeZRep.appendChild(nodeIOTotal);
            this.rootPacket.appendChild(nodeZRep);
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean xmlSaveDOMDocument(String xmlFilePath) throws ParserConfigurationException {
        if (this.buffer.length < 5) {
            return false;
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            this.doc.setXmlStandalone(true);
            this.rootElement = this.doc.createElement("KSEF");
            this.doc.appendChild(this.rootElement);
            this.rootElement.setAttribute("xmlns", "http://www.ics-market.com.ua");
            Element header = this.doc.createElement("HEADER");
            this.rootElement.appendChild(header);
            header.appendChild(this.doc.createComment("Model of fiscal printer"));
            Element model = this.doc.createElement("MODEL");
            try {
                model.appendChild(this.doc.createTextNode(new String(Arrays.copyOfRange(this.buffer, 4, 13), "Cp1251").replace('\u0000', ' ').trim()));
            }
            catch (UnsupportedEncodingException e) {
                msg.err(e.toString());
            }
            header.appendChild(model);
            header.appendChild(this.doc.createComment("Firmware version"));
            Element firmware = this.doc.createElement("FIRMWARE");
            try {
                firmware.appendChild(this.doc.createTextNode(new String(Arrays.copyOfRange(this.buffer, 13, 18), "Cp1251").replace('\u0000', ' ').trim()));
            }
            catch (UnsupportedEncodingException e) {
                msg.err(e.toString());
            }
            header.appendChild(firmware);
            int i = 18;
            long packetID = 0L;
            while (i < this.buffer.length - 2) {
                switch (this.buffer[i]) {
                    case 0: {
                        KSEF_REC_START tagSTART = new KSEF_REC_START();
                        byte[] buf = new byte[116];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 116);
                        tagSTART.oper = buf[0];
                        tagSTART.sectorsCount = buf[1];
                        tagSTART.sendDateTime = TransformToXml.getDate(Arrays.copyOfRange(buf, 2, 6));
                        tagSTART.recvDateTime = TransformToXml.getDate(Arrays.copyOfRange(buf, 6, 10));
                        tagSTART.recordsCount = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 10, 12));
                        tagSTART.receiptType = buf[12];
                        tagSTART.receiptDateTime = TransformToXml.getDate(Arrays.copyOfRange(buf, 13, 17));
                        try {
                            tagSTART.regInfo.serialNumber = new String(Arrays.copyOfRange(buf, 17, 28), "Cp1251").replace('\u0000', ' ').trim();
                            tagSTART.regInfo.fiscalNumber = new String(Arrays.copyOfRange(buf, 28, 39), "Cp1251").replace('\u0000', ' ').trim();
                            tagSTART.regInfo.taxNumber = new String(Arrays.copyOfRange(buf, 39, 55), "Cp1251").replace('\u0000', ' ').trim();
                            tagSTART.cashierName = new String(Arrays.copyOfRange(buf, 55, 71), "Cp1251").replace('\u0000', ' ').trim();
                        }
                        catch (UnsupportedEncodingException e) {
                            msg.err(e.toString());
                        }
                        tagSTART.mac.tel_Identifier = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 71, 73));
                        tagSTART.mac.tel_Length = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 73, 77));
                        tagSTART.mac.flags_TLG = buf[77];
                        tagSTART.mac.vk_ENC = Arrays.copyOfRange(buf, 78, 80);
                        tagSTART.mac.vk_MAC = Arrays.copyOfRange(buf, 80, 82);
                        tagSTART.mac.id_SAM = Arrays.copyOfRange(buf, 82, 86);
                        tagSTART.mac.nt_SAM = Arrays.copyOfRange(buf, 86, 90);
                        tagSTART.mac.nt_SESSION = Arrays.copyOfRange(buf, 90, 92);
                        tagSTART.mac.id_DEV = Arrays.copyOfRange(buf, 92, 96);
                        tagSTART.mac.data_MAC = Arrays.copyOfRange(buf, 96, 100);
                        tagSTART.md5 = Arrays.copyOfRange(buf, 100, 116);
                        i += 128;
                        if (this.xml_tagSTART(tagSTART, packetID)) break;
                        msg.out("tagSTART failed.");
                        return false;
                    }
                    case 1: 
                    case 2: {
                        KSEF_REC_SALE tagSALE = new KSEF_REC_SALE();
                        byte[] buf = new byte[122];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 122);
                        tagSALE.oper = buf[0];
                        tagSALE.tax = buf[1];
                        tagSALE.number = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 2, 4));
                        tagSALE.itemCode = Arrays.copyOfRange(buf, 4, 12);
                        try {
                            tagSALE.itemName = new String(Arrays.copyOfRange(buf, 12, 108), "Cp1251").replace('\u0000', ' ').trim();
                        }
                        catch (UnsupportedEncodingException e) {
                            msg.err(e.toString());
                        }
                        tagSALE.itemSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 108, 112));
                        if (buf[120] > 128) {
                            tagSALE.itemQty = 1000;
                            tagSALE.itemQtyPcn = (byte)3;
                        } else {
                            tagSALE.itemQty = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 112, 116));
                            tagSALE.itemQtyPcn = (byte)(buf[120] & 0x3F);
                            tagSALE.itemUsePcn = buf[121];
                        }
                        tagSALE.itemPrice = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 116, 120));
                        i += 128;
                        if (this.xml_tagSALE(tagSALE)) break;
                        msg.out("tagSALE failed.");
                        return false;
                    }
                    case 3: 
                    case 4: {
                        KSEF_REC_DISCOUNT tagDISCOUNT = new KSEF_REC_DISCOUNT();
                        byte[] buf = new byte[93];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 93);
                        tagDISCOUNT.oper = buf[0];
                        tagDISCOUNT.discountMethod = buf[1];
                        tagDISCOUNT.number = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 2, 4));
                        tagDISCOUNT.discountType = buf[4];
                        tagDISCOUNT.discountPercent = tagDISCOUNT.discountType == 0 ? 0 : TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 5, 9));
                        tagDISCOUNT.discountSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 9, 13));
                        int ii = 0;
                        while (ii < 8) {
                            int j = ii * 4;
                            tagDISCOUNT.discountTaxSum[ii] = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 13 + j, 17 + j));
                            ++ii;
                        }
                        try {
                            tagDISCOUNT.discTransactID = new String(Arrays.copyOfRange(buf, 45, 61), "Cp1251").replace('\u0000', ' ').trim();
                            tagDISCOUNT.discountName = new String(Arrays.copyOfRange(buf, 61, 93), "Cp1251").replace('\u0000', ' ').trim();
                        }
                        catch (UnsupportedEncodingException e) {
                            msg.err(e.toString());
                        }
                        i += 128;
                        if (this.xml_tagDISCOUNT(tagDISCOUNT)) break;
                        msg.out("tagDISCOUNT failed.");
                        return false;
                    }
                    case 5: {
                        KSEF_REC_PAYMENT tagPAYMENT = new KSEF_REC_PAYMENT();
                        byte[] buf = new byte[76];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 76);
                        tagPAYMENT.oper = buf[0];
                        tagPAYMENT.paymentType = buf[1];
                        tagPAYMENT.number = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 2, 4));
                        tagPAYMENT.paymentSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 4, 8));
                        tagPAYMENT.paymentRem = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 8, 12));
                        try {
                            tagPAYMENT.paymentName = new String(Arrays.copyOfRange(buf, 12, 44), "Cp1251").replace('\u0000', ' ').trim();
                            tagPAYMENT.payTransactID = new String(Arrays.copyOfRange(buf, 44, 76), "Cp1251").replace('\u0000', ' ').trim();
                        }
                        catch (UnsupportedEncodingException e) {
                            msg.err(e.toString());
                        }
                        i += 128;
                        if (this.xml_tagPAYMENT(tagPAYMENT)) break;
                        msg.out("tagPAYMENT failed.");
                        return false;
                    }
                    case 6: 
                    case 7: {
                        KSEF_REC_IO tagIO = new KSEF_REC_IO();
                        byte[] buf = new byte[12];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 12);
                        tagIO.oper = buf[0];
                        tagIO.ioType = buf[1];
                        tagIO.number = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 2, 4));
                        tagIO.ioSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 4, 8));
                        tagIO.ioDrawerSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 8, 12));
                        i += 128;
                        if (this.xml_tagIO(tagIO)) break;
                        msg.out("tagIO failed.");
                        return false;
                    }
                    case 8: {
                        KSEF_REC_COMMENT tagCOMMENT = new KSEF_REC_COMMENT();
                        byte[] buf = new byte[116];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 116);
                        tagCOMMENT.oper = buf[0];
                        tagCOMMENT.commentType = buf[1];
                        tagCOMMENT.number = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 2, 4));
                        try {
                            tagCOMMENT.commentText = new String(Arrays.copyOfRange(buf, 4, 112), "Cp1251").replace('\u0000', ' ').trim();
                        }
                        catch (UnsupportedEncodingException e) {
                            msg.err(e.toString());
                        }
                        i += 128;
                        if (this.xml_tagCOMMENT(tagCOMMENT)) break;
                        msg.out("tagCOMMENT failed.");
                        return false;
                    }
                    case 10: {
                        KSEF_REC_VOID tagVOID = new KSEF_REC_VOID();
                        byte[] buf = new byte[8];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 8);
                        tagVOID.oper = buf[0];
                        tagVOID.rfu = buf[1];
                        tagVOID.number = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 2, 4));
                        tagVOID.voidFO = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 4, 6));
                        tagVOID.voidLO = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 6, 8));
                        i += 128;
                        if (this.xml_tagVOID(tagVOID)) break;
                        msg.out("tagVOID failed.");
                        return false;
                    }
                    case 14: {
                        KSEF_REC_CANCEL tagCANCEL = new KSEF_REC_CANCEL();
                        byte[] buf = new byte[3];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 3);
                        tagCANCEL.oper = buf[0];
                        tagCANCEL.number = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 1, 3));
                        i += 128;
                        if (this.xml_tagCANCEL(tagCANCEL)) break;
                        msg.out("tagCANCEL failed.");
                        return false;
                    }
                    case 15: {
                        KSEF_REC_RECEIPT_END tagEND = new KSEF_REC_RECEIPT_END();
                        byte[] buf = new byte[126];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 126);
                        tagEND.oper = buf[0];
                        tagEND.number = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 1, 3));
                        tagEND.receiptNo = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 3, 7));
                        int ii = 0;
                        while (ii < 7) {
                            int j = ii * 17;
                            tagEND.receiptTax[ii] = new KSEF_REC_RECEIPT_TAX();
                            tagEND.receiptTax[ii].taxFlags = buf[7 + j];
                            tagEND.receiptTax[ii].baseTaxPercent = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 8 + j, 10 + j));
                            tagEND.receiptTax[ii].addTaxPercent = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 10 + j, 12 + j));
                            tagEND.receiptTax[ii].baseTaxSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 12 + j, 16 + j));
                            tagEND.receiptTax[ii].addTaxSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 16 + j, 20 + j));
                            tagEND.receiptTax[ii].turnSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 20 + j, 24 + j));
                            ++ii;
                        }
                        i += 128;
                        if (this.xml_tagEND(tagEND)) break;
                        msg.out("tagEND failed.");
                        return false;
                    }
                    case 32: {
                        KSEF_REC_PERS tagPERS = new KSEF_REC_PERS();
                        byte[] buf = new byte[74];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 74);
                        tagPERS.oper = buf[0];
                        tagPERS.sectorsCount = buf[1];
                        tagPERS.sendDateTime = TransformToXml.getDate(Arrays.copyOfRange(buf, 2, 6));
                        tagPERS.recvDateTime = TransformToXml.getDate(Arrays.copyOfRange(buf, 6, 10));
                        tagPERS.regResult = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 10, 12));
                        tagPERS.reserved1 = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 12, 14));
                        tagPERS.reserved2 = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 14, 16));
                        tagPERS.reserved3 = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 16, 18));
                        try {
                            tagPERS.regInfo.serialNumber = new String(Arrays.copyOfRange(buf, 18, 29), "Cp1251").replace('\u0000', ' ').trim();
                            tagPERS.regInfo.fiscalNumber = new String(Arrays.copyOfRange(buf, 29, 40), "Cp1251").replace('\u0000', ' ').trim();
                            tagPERS.regInfo.taxNumber = new String(Arrays.copyOfRange(buf, 40, 56), "Cp1251").replace('\u0000', ' ').trim();
                        }
                        catch (UnsupportedEncodingException e) {
                            msg.err(e.toString());
                        }
                        tagPERS.typeRRO = buf[56];
                        tagPERS.typeRRODPS = buf[57];
                        tagPERS.md5 = Arrays.copyOfRange(buf, 58, 74);
                        i += 128;
                        if (this.xml_tagPERS(tagPERS, packetID)) break;
                        msg.out("tagPERS failed.");
                        return false;
                    }
                    case 48: {
                        int j;
                        KSEF_REC_Z_REPORT tagZ_REPORT = new KSEF_REC_Z_REPORT();
                        byte[] buf = new byte[512];
                        buf = Arrays.copyOfRange(this.buffer, i, i + 459);
                        tagZ_REPORT.oper = buf[0];
                        tagZ_REPORT.sectorsCount = buf[1];
                        tagZ_REPORT.sendDateTime = TransformToXml.getDate(Arrays.copyOfRange(buf, 2, 6));
                        tagZ_REPORT.recvDateTime = TransformToXml.getDate(Arrays.copyOfRange(buf, 6, 10));
                        tagZ_REPORT.reportNo = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 10, 12));
                        tagZ_REPORT.reportDateTime = TransformToXml.getDate(Arrays.copyOfRange(buf, 12, 16));
                        tagZ_REPORT.saleRcptCount = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 16, 20));
                        tagZ_REPORT.refundRcptCount = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 20, 24));
                        Calendar calendar = Calendar.getInstance();
                        int ii = 0;
                        while (ii < 8) {
                            j = ii * 31;
                            tagZ_REPORT.recReportTaxArr[ii] = new KSEF_REC_REPORT_TAX();
                            tagZ_REPORT.recReportTaxArr[ii].taxFlags = buf[24 + j];
                            try {
                                short date = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 25 + j, 27 + j));
                                byte year = (byte)(date >> 9 & 0xF);
                                byte month = (byte)(date >> 5 & 0xF);
                                byte day = (byte)(date & 0x1F);
                                calendar.set(2000 + year, month > 0 ? month - 1 : 0, day > 0 ? day : (byte)1, 0, 0, 0);
                                tagZ_REPORT.recReportTaxArr[ii].taxDate = calendar.getTime();
                            }
                            catch (Exception e) {
                                msg.err(e.toString());
                                calendar.set(2000, 0, 1);
                                tagZ_REPORT.recReportTaxArr[ii].taxDate = calendar.getTime();
                            }
                            tagZ_REPORT.recReportTaxArr[ii].baseTaxPercent = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 27 + j, 29 + j));
                            tagZ_REPORT.recReportTaxArr[ii].addTaxPercent = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 29 + j, 31 + j));
                            tagZ_REPORT.recReportTaxArr[ii].baseTaxInSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 31 + j, 35 + j));
                            tagZ_REPORT.recReportTaxArr[ii].baseTaxOutSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 35 + j, 39 + j));
                            tagZ_REPORT.recReportTaxArr[ii].addTaxInSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 39 + j, 43 + j));
                            tagZ_REPORT.recReportTaxArr[ii].addTaxOutSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 43 + j, 47 + j));
                            tagZ_REPORT.recReportTaxArr[ii].turnInSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 47 + j, 51 + j));
                            tagZ_REPORT.recReportTaxArr[ii].turnOutSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 51 + j, 55 + j));
                            ++ii;
                        }
                        ii = 0;
                        while (ii < 10) {
                            j = ii * 4;
                            tagZ_REPORT.saleSumArr[ii] = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 272 + j, 276 + j));
                            ++ii;
                        }
                        ii = 0;
                        while (ii < 10) {
                            j = ii * 4;
                            tagZ_REPORT.refundSumArr[ii] = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 312 + j, 316 + j));
                            ++ii;
                        }
                        tagZ_REPORT.inSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 352, 356));
                        tagZ_REPORT.outSum = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 356, 360));
                        try {
                            tagZ_REPORT.regInfo.serialNumber = new String(Arrays.copyOfRange(buf, 360, 371), "Cp1251").replace('\u0000', ' ').trim();
                            tagZ_REPORT.regInfo.fiscalNumber = new String(Arrays.copyOfRange(buf, 371, 382), "Cp1251").replace('\u0000', ' ').trim();
                            tagZ_REPORT.regInfo.taxNumber = new String(Arrays.copyOfRange(buf, 382, 398), "Cp1251").replace('\u0000', ' ').trim();
                            tagZ_REPORT.cashierName = new String(Arrays.copyOfRange(buf, 398, 414), "Cp1251").replace('\u0000', ' ').trim();
                        }
                        catch (UnsupportedEncodingException e) {
                            msg.err(e.toString());
                        }
                        tagZ_REPORT.mac.tel_Identifier = TransformToXml.byteArrayToShort(Arrays.copyOfRange(buf, 414, 416));
                        tagZ_REPORT.mac.tel_Length = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 416, 420));
                        tagZ_REPORT.mac.flags_TLG = buf[420];
                        tagZ_REPORT.mac.vk_ENC = Arrays.copyOfRange(buf, 421, 423);
                        tagZ_REPORT.mac.vk_MAC = Arrays.copyOfRange(buf, 423, 425);
                        tagZ_REPORT.mac.id_SAM = Arrays.copyOfRange(buf, 425, 429);
                        tagZ_REPORT.mac.nt_SAM = Arrays.copyOfRange(buf, 429, 433);
                        tagZ_REPORT.mac.nt_SESSION = Arrays.copyOfRange(buf, 433, 435);
                        tagZ_REPORT.mac.id_DEV = Arrays.copyOfRange(buf, 435, 439);
                        tagZ_REPORT.mac.data_MAC = Arrays.copyOfRange(buf, 439, 443);
                        tagZ_REPORT.md5 = Arrays.copyOfRange(buf, 443, 459);
                        i += 512;
                        if (this.xml_tagZ_REPORT(tagZ_REPORT, packetID)) break;
                        msg.out("tagZ_REPORT failed.");
                        return false;
                    }
                    case 99: {
                        byte[] buf = new byte[4];
                        buf = Arrays.copyOfRange(this.buffer, i + 1, i + 5);
                        packetID = TransformToXml.byteArrayToInt(Arrays.copyOfRange(buf, 0, 4));
                        i += 5;
                    }
                }
            }
            header.appendChild(this.doc.createComment("Serial number"));
            Element sn = this.doc.createElement("SN");
            sn.appendChild(this.doc.createTextNode(this.serial));
            header.appendChild(sn);
            header.appendChild(this.doc.createComment("Date of report creation"));
            Element reportdate = this.doc.createElement("DATE");
            reportdate.appendChild(this.doc.createTextNode(this.dtf.format(new Date(new File(this.sourceFilePath).lastModified()))));
            header.appendChild(reportdate);
            header.appendChild(this.doc.createComment("POS id"));
            Element pos_id = this.doc.createElement("POSID");
            try {
                pos_id.appendChild(this.doc.createTextNode(new String(LoadConfig.getPOSid().getBytes(), "UTF-8")));
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
            header.appendChild(pos_id);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = new StreamResult(new File(xmlFilePath));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            msg.err(pce.toString());
            return false;
        }
        catch (TransformerException tfe) {
            msg.err(tfe.toString());
            return false;
        }
        catch (DOMException e) {
            msg.err(e.toString());
            return false;
        }
        return true;
    }
}

