/*
 * Decompiled with CFR 0.152.
 */
package KSEFSvcPackage;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class LoadConfig {
    private String IN_DATA_STRING_VALUE;
    private String OUT_DATA_STRING_VALUE;
    private String BACKUP_DATA_STRING_VALUE;
    private boolean DATA_TRANSMITTER_ENABLED = false;
    private String SERVER_IP = "localhost";
    private int SERVER_PORT = 2188;
    private static String POSid;
    private static String sDirSeparator;

    static {
        sDirSeparator = System.getProperty("file.separator");
    }

    public LoadConfig(String server, int port) throws IOException {
        Properties props;
        this.SERVER_IP = server;
        this.SERVER_PORT = port;
        String currentDir = LoadConfig.getCurrentDir();
        this.IN_DATA_STRING_VALUE = String.valueOf(currentDir) + sDirSeparator + "IN";
        this.OUT_DATA_STRING_VALUE = String.valueOf(currentDir) + sDirSeparator + "OUT";
        this.BACKUP_DATA_STRING_VALUE = String.valueOf(currentDir) + sDirSeparator + "BACKUP";
        POSid = "";
        InputStream stream = null;
        InputStreamReader reader = null;
        try {
            stream = new FileInputStream(String.valueOf(currentDir) + sDirSeparator + "config.ini");
            reader = new InputStreamReader(stream, "UTF-8");
            props = new Properties();
            try {
                props.load(reader);
            }
            catch (IOException e) {
                stream.close();
                if (reader != null) {
                    reader.close();
                }
                return;
            }
        }
        finally {
            stream.close();
            if (reader != null) {
                reader.close();
            }
        }
        POSid = props.getProperty("POS_ID", POSid);
        this.IN_DATA_STRING_VALUE = props.getProperty("IN_DATA_STRING_VALUE", this.IN_DATA_STRING_VALUE);
        this.OUT_DATA_STRING_VALUE = props.getProperty("OUT_DATA_STRING_VALUE", this.OUT_DATA_STRING_VALUE);
        this.BACKUP_DATA_STRING_VALUE = props.getProperty("BACKUP_DATA_STRING_VALUE", this.BACKUP_DATA_STRING_VALUE);
        this.DATA_TRANSMITTER_ENABLED = Boolean.parseBoolean(props.getProperty("DATA_TRANSMITTER_ENABLED", Boolean.toString(this.DATA_TRANSMITTER_ENABLED)).trim());
        this.SERVER_IP = props.getProperty("SERVER_IP", this.SERVER_IP);
        this.SERVER_PORT = Integer.parseInt(props.getProperty("SERVER_PORT", Integer.toString(this.SERVER_PORT)).trim());
    }

    private static String getCurrentDir() {
        String path = System.getProperty("java.class.path");
        return path.substring(path.lastIndexOf(":") + 1, path.lastIndexOf(sDirSeparator) + 1);
    }

    public static String getPOSid() {
        return POSid;
    }

    public String getIN_DATA_STRING_VALUE() {
        return this.IN_DATA_STRING_VALUE;
    }

    public String getOUT_DATA_STRING_VALUE() {
        return this.OUT_DATA_STRING_VALUE;
    }

    public String getBACKUP_DATA_STRING_VALUE() {
        return this.BACKUP_DATA_STRING_VALUE;
    }

    public String getSERVER_IP() {
        return this.SERVER_IP;
    }

    public int getSERVER_PORT() {
        return this.SERVER_PORT;
    }

    public boolean getDATA_TRANSMITTER_ENABLED() {
        return this.DATA_TRANSMITTER_ENABLED;
    }
}

