/*
 * Decompiled with CFR 0.152.
 */
package KsefSrvPackage;

import KsefSrvPackage.PrintMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PacketServer {
    private static JTextArea area;
    private static boolean debug;
    private static int port;
    private static String storage;
    static PrintMessage msg;

    static {
        debug = false;
        port = 2188;
        msg = new PrintMessage();
    }

    public PacketServer(int mport, boolean mdebug) {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            msg.err(e.toString());
        }
        debug = mdebug;
        port = mport;
        if (debug) {
            JFrame f = new JFrame("\u0421\u0435\u0440\u0432\u0435\u0440 \u041a\u0421\u0415\u0424");
            f.setDefaultCloseOperation(3);
            f.setSize(350, 250);
            f.setLayout(new BorderLayout());
            f.setMinimumSize(new Dimension(350, 250));
            area = new JTextArea();
            f.add((Component)area, "North");
            JButton button = new JButton();
            button.setText("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
            button.setVisible(true);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    area.setText(null);
                    area.append("LISTEN PORT " + port + "\n");
                    area.append("Wait connect...\n");
                }
            });
            f.add((Component)button, "South");
            JScrollPane sp = new JScrollPane(area);
            f.getContentPane().add(sp);
            f.setAlwaysOnTop(true);
            f.setVisible(true);
        }
    }

    private static String getCurrentDir() {
        String path = System.getProperty("java.class.path");
        return path.substring(path.lastIndexOf(":") + 1, path.lastIndexOf(File.separator) + 1);
    }

    private void loadConfig() throws IOException {
        String currentDir = PacketServer.getCurrentDir();
        storage = String.valueOf(currentDir) + File.separator + "KSEFSTORAGE";
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(String.valueOf(currentDir) + File.separator + "server.ini"));
        }
        catch (IOException e) {
            return;
        }
        if (props.getProperty("LISTEN_PORT") != null) {
            port = Integer.parseInt(props.getProperty("LISTEN_PORT"));
        }
        if (props.getProperty("STORAGE_PATH") != null) {
            storage = String.valueOf(props.getProperty("STORAGE_PATH")) + File.separator + "KSEFSTORAGE";
        }
    }

    public void start() {
        new RunService();
    }

    public void stopServer() {
        msg.out("Server stopped...");
        System.exit(0);
    }

    private static class RunService
    extends Thread {
        ServerSocket ss;

        public RunService() {
            try {
                this.ss = new ServerSocket(port);
            }
            catch (IOException e) {
                msg.err(e.toString());
            }
            if (debug) {
                area.append("LISTEN PORT " + port + "\n");
                area.append("Wait connect...\n");
            }
            this.start();
            msg.out("Server started...");
        }

        @Override
        public void run() {
            while (true) {
                Socket socket = null;
                try {
                    socket = this.ss.accept();
                }
                catch (IOException e) {
                    msg.err(e.toString());
                }
                try {
                    new Thread(new SocketProcessor(socket)).start();
                    continue;
                }
                catch (Throwable e) {
                    msg.err(e.toString());
                    continue;
                }
                break;
            }
        }
    }

    private static class SocketProcessor
    implements Runnable {
        private Socket s;
        private InputStream is;
        private DataInputStream din;

        private SocketProcessor(Socket s) throws Throwable {
            this.s = s;
            this.is = s.getInputStream();
            this.din = new DataInputStream(this.is);
        }

        @Override
        public void run() {
            block11: {
                try {
                    try {
                        this.readInputData(this.din);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.s.close();
                        }
                        catch (Throwable throwable2) {}
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.s.close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.s.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            msg.out("Client " + this.s.getRemoteSocketAddress().toString() + " processing finished");
        }

        private void readInputData(DataInputStream inputStream) throws Throwable {
            int count;
            File dir;
            String serialNumber = inputStream.readUTF();
            long fileSize = inputStream.readLong();
            String fileName = inputStream.readUTF();
            if (debug) {
                Date curTime = new Date();
                DateFormat dtfrm = DateFormat.getDateTimeInstance();
                area.append("----- \u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435: " + dtfrm.format(curTime) + " -----\n");
                area.append("\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 " + serialNumber + "\n");
                area.append("\u0418\u043c\u044f \u0444\u0430\u0439\u043b\u0430: " + fileName + "\n");
                area.append("\u0420\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430: " + fileSize + " \u0431\u0430\u0439\u0442\n");
            }
            if (!(dir = new File(String.valueOf(storage) + File.separator + serialNumber)).exists()) {
                dir.mkdirs();
            }
            String path = String.valueOf(dir.getPath()) + File.separator + fileName;
            if (debug) {
                area.append("\u041f\u0443\u0442\u044c: " + path + "\n");
            }
            byte[] buffer = new byte[0x2000000];
            FileOutputStream outF = new FileOutputStream(path);
            int total = 0;
            while ((count = inputStream.read(buffer)) != -1) {
                outF.write(buffer, 0, count);
                if ((long)(total += count) == fileSize) break;
            }
            outF.flush();
            outF.close();
            if (debug) {
                area.append("\u0424\u0430\u0439\u043b \u043f\u0440\u0438\u043d\u044f\u0442\n---------------------------------\n");
                area.append("Wait connect...\n");
            }
        }
    }
}

