/*
 * Decompiled with CFR 0.152.
 */
package KsefSrvPackage;

import KsefSrvPackage.PacketServer;
import KsefSrvPackage.PrintMessage;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonInitException;

public class MainClass
implements Daemon {
    private static PacketServer server;
    private boolean debug = false;
    private int port = 2188;
    static PrintMessage msg;

    static {
        msg = new PrintMessage();
    }

    public static void main(String[] args) {
        msg.out("This class designed to run via jsvc");
        System.exit(0);
    }

    @Override
    public void init(DaemonContext context) throws DaemonInitException, Exception {
        msg.out("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f...");
        Options options = new Options();
        options.addOption("d", "debug", false, "print debug informaton");
        options.addOption("h", "help", false, "display help informaton");
        OptionBuilder.withLongOpt("port");
        OptionBuilder.withDescription("use port PORT for connecting");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("PORT");
        options.addOption(OptionBuilder.create());
        try {
            CommandLine line = new PosixParser().parse(options, context.getArguments());
            if (line.hasOption("port")) {
                this.port = Integer.parseInt(line.getOptionValue("port"));
            }
            if (line.hasOption("d")) {
                this.debug = true;
            }
            if (line.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("KsefSrvnix", options);
            }
        }
        catch (NumberFormatException | ParseException e) {
            msg.out("\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043a\u043e\u043c\u0430\u043d\u0434\u043d\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0438");
            msg.err(e.toString());
            System.exit(0);
        }
        server = new PacketServer(this.port, this.debug);
    }

    @Override
    public void start() throws Exception {
        msg.out("\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c \u0441\u0435\u0440\u0432\u0435\u0440 (port: " + this.port + ", debug: " + this.debug + ")...");
        server.start();
    }

    @Override
    public void stop() throws Exception {
        msg.out("\u041e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0441\u0435\u0440\u0432\u0435\u0440...");
        server.stopServer();
    }

    @Override
    public void destroy() {
        msg.out("\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d.");
    }
}

